-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    if not self.loaded then
      self.armyCount = 0
      self.counted = false
      self.deactivate = false
    end    
    self.playerDefeated:LinkToTarget("defeat")
  end
  
  if self.counted and not self.deactivate then
    if self.armyCount < 5 then
      self.playerDefeated:TriggerAllTargets()
      self.deactivate = true
    end
  end
end

function OnTrigger(self, sourceName, targetName)
  if targetName == "startArmyCount" then
    self.armyCount = self.armyCount + 1
    self.counted = true
  elseif targetName == "armyKillDec" then
    self.armyCount = self.armyCount - 1
  elseif targetName == "deactivate" then
    self.deactivate = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  CreateTriggerSources(self)
	  self.loaded = true
	  self.armyCount = ar:Read()
    self.counted = ar:Read()
    self.deactivate = ar:Read()
  elseif (ar:IsSaving()) then
	  ar:Write(self.armyCount)
    ar:Write(self.counted)
    ar:Write(self.deactivate)
  end  
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("startArmyCount")
  self:AddTriggerTarget("armyKillDec")
  self:AddTriggerTarget("deactivate")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("playerDefeated")
end
